﻿using System.Net;
using Sitecore.Data;
using Sitecore.SecurityModel;
using Smartling.Connector.Diagnostics;
using Smartling.Connector.Translation;
using System;
using System.Web;
using Smartling.Connector.Callback;

namespace Smartling.Connector.Shell
{
  public partial class CallbackHandler : System.Web.UI.Page
  {
    private const string FileUriQueryString = "fileUri";
    private const string LocaleQueryString = "locale";
    
    protected void Page_Load(object sender, EventArgs e)
    {
      var tokenService = new TokenService();
      if (Page.IsCrossPagePostBack)
      {
        return;
      }

      if (!tokenService.ValidateToken(Request[ModuleConstants.CallbackTokenParameter]))
      {
        // Better to return HttpStatusCode.NotFound but in this case
        // Smartling callback service will repeat callback
        Response.StatusCode = (int)HttpStatusCode.OK;
        return;
      }

      var fileUri = HttpContext.Current.Request.QueryString[FileUriQueryString];
      var locale = HttpContext.Current.Request.QueryString[LocaleQueryString];
      SmartlingLogger.Log.Info(string.Format("Callback: started processing request, fileUri=\"{0}\", smartling locale=\"{1}\"", fileUri, locale));

      try
      {
        if (ValidateParameters(fileUri, locale))
        {
          var processor = new CallbackProcessor();
          processor.ProcessRequest(fileUri, locale);
        }
      }
      catch (Exception ex)
      {
        SmartlingLogger.Log.Error(string.Format("Callback: Error during processing callback, fileUri=\"{0}\", smartling locale=\"{1}\"",
          fileUri, locale), ex);
      }

      Response.StatusCode = (int)HttpStatusCode.OK; // Smartling callback service expects for 200
      SmartlingLogger.Log.Info(string.Format("Callback: successfully processed, fileUri=\"{0}\", smartling locale=\"{1}\"", fileUri, locale));
    }


    public static bool ValidateParameters(string fileUri, string locale)
    {
      if (string.IsNullOrEmpty(fileUri) || string.IsNullOrEmpty(locale))
      {
        SmartlingLogger.Log.Error(string.Format("Callback parameters are invalid. Received values fileUri=\"{0}\", smartling locale=\"{1}\"", fileUri, locale));
        return false;
      }

      return true;
    }
  }
}
